﻿var distribute = {
    context: $(".v-distributeIndex"),
    datatable: null,
    refreshDataTable: function () {
        distribute.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        var isEmail = function (data) { return _.contains([Enum.DistributionType.Email, Enum.DistributionType.EmailReminder], data.Type.toString()); };
        var isSMSDistribution = function (data) { return _.contains([Enum.DistributionType.SMS], data.Type.toString()); };
        var isEmailOrSMS = function (data) { return _.contains([Enum.DistributionType.Email, Enum.DistributionType.EmailReminder, Enum.DistributionType.SMS], data.Type.toString()); };
        var isNotRunning = function (data) { return data.Status != Enum.TaskStatus.Running };
        var isNotRunningNotCompleted = function (data) { return data.Status != Enum.TaskStatus.Running && data.Status != Enum.TaskStatus.Completed; };
        var isNotFacebookAndTwitter = function (data) { return data.Type != Enum.DistributionType.Twitter && data.Type != Enum.DistributionType.Facebook; }
        var isPendingOrRunning = function (data) { return data.Status == Enum.TaskStatus.Pending || data.Status == Enum.TaskStatus.Running }
        var columns = [];
        columns.push({ "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Type": "numeric" })
        columns.push({ "Name": "Name", "Title": resources.DistributionName, "Data": "Name", "Width": "25%", "HideInSelector": true })
        columns.push({ "Name": "Type", "Title": resources.Type, "Data": "TypeEnum", "HideInSelector": true, "Type": "enum", "EnumType": "DistributionType" })
        columns.push({ "Name": "SendDate", "Title": resources.SendDate, "Data": "SendDate", "Type": "date", "Width": "150px" })
        columns.push({ "Name": "Status", "Title": resources.Status, "Data": "StatusEnum", "Type": "enum", "EnumType": "TaskStatus" })
        columns.push({ "Name": "Sent", "Title": resources.Sent, "Data": "Sent", "Type": "numeric" })
        columns.push({ "Name": "Recipients", "Title": resources.Recipients, "Data": "Recipients", "Type": "numeric" })
        if (enableEnhancedDistributionStatuses) {
            columns.push({ "Name": "Delivered", "Title": resources.Delivered, "Data": "Delivered", "Type": "numeric" })
        }
        columns.push({ "Name": "Bounced", "Title": resources.Undelivered, "Data": "Bounced", "Type": "numeric" })
        columns.push({ "Name": "Started", "Title": resources.Started, "Data": "NotCompleted", "Type": "numeric" })
        columns.push({ "Name": "Completed", "Title": resources.Completed, "Data": "Completed", "Type": "numeric" });

        var contextMenuItems = [
            { "Action": "editSchedule", "Label": resources.EditSchedule, "DisplayCondition": isNotRunning && isEmailOrSMS },
            { "Divider": true },
            { "Action": "delete", "Label": resources.Delete, "Visible": canModify, "DisplayCondition": isNotRunningNotCompleted },
            { "Action": "edit", "Label": resources.Properties, "Visible": canModify, "DisplayCondition": isNotFacebookAndTwitter },
            { "Divider": true },
            { "Action": "stop", "Label": resources.Stop, "Visible": canModify, "DisplayCondition": isEmailOrSMS && isPendingOrRunning },
            { "Action": "sendnow", "Label": resources.SendNow, "Visible": canModify, "DisplayCondition": isEmailOrSMS && isNotRunningNotCompleted },
            { "Action": "history", "Label": resources.History, "DisplayCondition": isEmailOrSMS },
            { "Divider": true },
            { "Action": "status", "Label": resources.ViewStatus },
            { "Action": "refreshdistributionstatus", "Label": resources.RefreshDistributionStatus, "DisplayCondition": isSMSDistribution}
        ];

        if ($("#CanSendEmails").val() == "True") {
            contextMenuItems.push({
                "Action": "sendtest", "Label": resources.SendTestEmail, "DisplayCondition": isNotRunningNotCompleted && isEmail
            });
        }

        this.datatable = $(".h-distribute-table", distribute.context).a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxAction: a4.getSurveyAction("GetDistributions", "Distribute"),
            columns: columns,
            defaultSorting: { Column: "Id", Ascending: false },
            lengthMenu: [
                [10, 20, 50, 100, 500, 1000],
                ['10', '20', '50', '100', '500', '1000']
            ],
            stateKey: "Distribute",
            autoUpdate: true,
            quickFilter: {
                "Items": [
                    { "Label": resources.PendingAndRunning, "AjaxParams": { "notCompleted": true } },
                ]
            },
            localizableTexts: { "All": resources.AllDistributions, "Search": resources.SearchDistributions },
            contextMenuItems: contextMenuItems,
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "status":
                        distribute.displayStatus(row);
                        break
                    case "edit":
                        distribute.editItem(row);
                        break;
                    case "editSchedule":
                        modalDialog.showWindow(a4.getAction("DistributionScheduleEditor", "Shared", "Home", { surveyId: a4.getSurveyId(), distributionId: row.Id }), 600, 850, { afterClose: function () { distribute.refreshDataTable(); }, focusFirstField: false });
                        break;
                    case "history":
                        modalDialog.showWindow(a4.getSurveyAction("DistributionHistory", "Distribute", { distributionId: row.Id, name: row.Name }), 600, 950);
                        break;
                    case "stop":
                        a4.callServerMethod(a4.getSurveyAction("StopDistribution", "Distribute"), { distributionId: row.Id }, function (result) {
                            distribute.refreshDataTable();
                        });
                        break;
                    case "sendnow":
                        a4.callServerMethod(a4.getSurveyAction("SendDistributionNow", "Distribute"), { distributionId: row.Id }, function (result) {
                            distribute.refreshDataTable();
                        });
                        break;
                    case "sendtest":
                        modalDialog.showWindow(a4.getSurveyAction("SendTestEmail", "Distribute", { id: row.Id }), 400, 600);
                        break;
                    case "delete":
                        modalDialog.showConfirmDialog(confirmDeleteSurveyResources, function () {
                            a4.callServerMethod(a4.getSurveyAction("DeleteDistribution", "Distribute"), { distributionId: row.Id },
                                function (result) {
                                    distribute.refreshDataTable();
                                });
                        }, 250, 500, true, { "name": row.Name });
                        break;
                    case "refreshdistributionstatus":
                        a4.callServerMethod(a4.getSurveyAction("RefreshDistributionStatuses", "Distribute"), { distributionId: row.Id }, function (result) {
                            distribute.refreshDataTable();
                        }, function (xhr) { if (xhr.status == 200) { distribute.refreshDataTable(); }});
                        break;
                }
            }
        });
    },
    displayStatus: function (item) {
        var height = 700;
        var width = 1000;

        if (item.Status == Enum.TaskStatus.Failed) {
            height = 200;
            width = 700;
        }

        switch (item.Type.toString()) {
            case Enum.DistributionType.Email:
            case Enum.DistributionType.EmailReminder:
                modalDialog.showWindow(a4.getSurveyAction("EmailDistributionStatus", "Distribute", { id: item.Id }), height, width);
                break;
            case Enum.DistributionType.SMS:
                modalDialog.showWindow(a4.getSurveyAction("SMSDistributionStatus", "Distribute", { id: item.Id }), height, width);
                break;
            default:
                modalDialog.showWindow(a4.getSurveyAction("DistributionStatus", "Distribute", { id: item.Id }), height, width);
                break;
        }
    },
    bindEvents: function () {
        distribute.context.on("click", ".h-copyDistribution", function () {
            modalDialog.showWindow(a4.getSurveyAction("CopyDistribution", "Distribute"), 600, 800, { afterClose: function () { distribute.refreshDataTable(); } });
        });

        distribute.context.on("click", ".h-exportBounces", function () {
            a4.showBusyBox();

            a4.callServerMethod(a4.getSurveyAction("ExportBounces", "Distribute"), {},
                function (result) {
                    a4.hideBusyBox();
                    window.location = a4.getSurveyAction("GetBouncesFile", "Distribute", { fileName: result });
                },
                function (error) {
                    a4.onAjaxPageMethodError(error);
                });
        });

        distribute.context.on("click", ".h-exportUndelivered", function () {
            a4.showBusyBox();

            a4.callServerMethod(a4.getSurveyAction("ExportUndelivered", "Distribute"), {},
                function (result) {
                    a4.hideBusyBox();
                    window.location = a4.getSurveyAction("GetUndeliveredFile", "Distribute", { fileName: result });
                },
                function (error) {
                    a4.onAjaxPageMethodError(error);
                });
        });

        distribute.context.on("click", ".h-viewSummary", function () {
            modalDialog.showWindow(a4.getSurveyAction("DistributionSummary", "Distribute"), 700, 900);
        });

        distribute.context.on("click", ".h-displayAmazonSESInfo", function () {
            modalDialog.showWindow(a4.getSurveyAction("AmazonSESInformation", "Distribute"), 365, 500);
        });
    },
    editItem: function (item) {
        switch (item.Type.toString()) {
            case Enum.DistributionType.Email:
            case Enum.DistributionType.EmailReminder:
                window.location = a4.getSurveyAction("EmailDistributionWizard", "Distribute", { id: item.Id });
                break;
            case Enum.DistributionType.PopUp:
                window.location = a4.getSurveyAction("PopUpDistributionWizard", "Distribute", { id: item.Id });
                break;
            case Enum.DistributionType.SMS:
                window.location = a4.getSurveyAction("SMSDistributionWizard", "Distribute", { id: item.Id });
                break;
        }
    }
}

$(document).ready(function () {
    if (distribute.context.length > 0) {
        distribute.initializeDataTable();
        distribute.bindEvents();
    }
});
